//
//  DHDSACNUniverseDetails.h
//  DHDMX
//
//  Created by Douglas Heriot on 3/03/12.
//  Copyright (c) 2012 Douglas Heriot Design. All rights reserved.
//

#import <Foundation/Foundation.h>

// Key saved in NSUserDefaults to persist a generated CID (that is, a UUID)
extern NSString * const DHDSACNCIDKey; // Defined as @"DHDMXSACNCID"

@interface DHDSACNIdentity : NSObject <NSCopying, NSCoding>
{
	NSData *_address;
	NSData *_CID;
	uint16_t _universe;
	BOOL _preview;
}

@property (readonly, copy) NSData *address;
@property (readonly, copy) NSData *CID;
@property (readonly) uint16_t universe;
@property (readonly) BOOL preview;

// Designated initialiser initWithUniverse:CID:preview:address:
- (id)initWithUniverse:(uint16_t)universe;
- (id)initWithUniverse:(uint16_t)universe CID:(NSData *)CID;
- (id)initWithUniverse:(uint16_t)universe CID:(NSData *)CID preview:(BOOL)preview;
- (id)initWithUniverse:(uint16_t)universe CID:(NSData *)CID preview:(BOOL)preview address:(NSData *)address;

+ (NSData *)generateCID;
+ (NSData *)sharedCID;

// Identity, with shared CID, default multicast, and preview off
+ (DHDSACNIdentity *)identityWithUniverse:(uint16_t)universe;

@end
